<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

namespace App\Http\Controllers;

use App\Models\Country;
use Illuminate\Http\Request;
use App\Models\VisaApplication;
use Captcha;

class FormController extends Controller
{
    public function saveData(Request $request)
    {
        // Validate the data
        $request->validate([
            'Visa_Application_Type' => 'required',
            'Visa_Case_Number' => 'required',
            'captcha' => 'required|captcha',
        ]);


        // Insert the data into the database
        VisaApplication::create([
            'Visa_Application_Type' => $request->Visa_Application_Type,
            'Visa_Case_Number' => $request->Visa_Case_Number,
        ]);


        // Redirect back or to a success page
        return view('page_two');
    }

    // return back()->with('success', 'Data submitted successfully!');

    public function refreshCaptcha()
{
    return response()->json(['captcha'=> captcha_img()]);
}
public function selectionVisaType()
{
    $countries = Country::all();

    return view('selection_visatype', compact('countries'));
}


}
