<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('countries', function (Blueprint $table) {
            $table->id();  // id - Primary key, AUTO_INCREMENT
            $table->char('countryCode', 2);  // countryCode - char(2)
            $table->string('countryName', 100);  // countryName - varchar(100)
            $table->char('currencyCode', 3)->nullable();  // currencyCode - char(3), nullable
            $table->char('fipsCode', 2)->nullable();  // fipsCode - char(2), nullable
            $table->char('isoNumeric', 4)->nullable();  // isoNumeric - char(4), nullable
            $table->string('north', 30)->nullable();  // north - varchar(30), nullable
            $table->string('south', 30)->nullable();  // south - varchar(30), nullable
            $table->string('east', 30)->nullable();  // east - varchar(30), nullable
            $table->string('west', 30)->nullable();  // west - varchar(30), nullable
            $table->string('capital', 100)->nullable();  // capital - varchar(100), nullable
            $table->string('continentName', 100)->nullable();  // continentName - varchar(100), nullable
            $table->char('continent', 2)->nullable();  // continent - char(2), nullable
            $table->string('languages', 100)->nullable();  // languages - varchar(100), nullable
            $table->char('isoAlpha3', 3)->nullable();  // isoAlpha3 - char(3), nullable
            $table->integer('geonameId')->nullable();  // geonameId - int(10), nullable
            $table->string('telephonePrefix', 10);  // telephonePrefix - varchar(10)
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('countries');
    }
};
