<?php

namespace Database\Seeders;

use Illuminate\Support\Facades\DB;  // Corrected import
use Illuminate\Database\Seeder;

class CountriesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('countries')->insert([ 
            [
                'countryCode' => 'US',
                'countryName' => 'United States',
                'currencyCode' => 'USD',
                'fipsCode' => 'US',
                'isoNumeric' => '840',
                'north' => '49.3457868',
                'south' => '24.396308',
                'east' => '-66.93457',
                'west' => '-125.00165',
                'capital' => 'Washington D.C.',
                'continentName' => 'North America',
                'continent' => 'NA',
                'languages' => 'en-US,es-US,haw,fr',
                'isoAlpha3' => 'USA',
                'geonameId' => 6252001,
                'telephonePrefix' => '+1'
            ],
            [
                'countryCode' => 'CA',
                'countryName' => 'Canada',
                'currencyCode' => 'CAD',
                'fipsCode' => 'CA',
                'isoNumeric' => '124',
                'north' => '83.113',
                'south' => '41.6765556',
                'east' => '-52.616667',
                'west' => '-141.0',
                'capital' => 'Ottawa',
                'continentName' => 'North America',
                'continent' => 'NA',
                'languages' => 'en-CA,fr-CA,iu',
                'isoAlpha3' => 'CAN',
                'geonameId' => 6251999,
                'telephonePrefix' => '+1'
            ],
            // Add more countries as needed
        ]);
    }
}
